// Background script for QPT extension: receives logs from content scripts
(function() {
  'use strict';

  function safeLog(level, args) {
    try {
      const prefix = '[QPT background]';
      if (!args) args = [];
      if (!Array.isArray(args)) args = [args];
      if (level === 'warn') console.warn(prefix, ...args);
      else if (level === 'error') console.error(prefix, ...args);
      else console.log(prefix, ...args);
    } catch (e) {
      // ignore
    }
  }

  if (typeof chrome !== 'undefined' && chrome.runtime && chrome.runtime.onMessage) {
    chrome.runtime.onMessage.addListener((message, sender) => {
      try {
        if (message && message.qpt_log) {
          const level = message.level || 'log';
          safeLog(level, message.qpt_log);
        }
      } catch (e) {
        safeLog('error', ['background message handler error', e]);
      }
    });
  }
})();
